package kr.co.kno.sample.controller;

import java.io.File;
import java.io.OutputStream;
import java.util.UUID;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import com.ibleaders.ibsheet.IBSheetDown;
import com.ibleaders.ibsheetLoader.IBSheetLoad;

/**
 * 
 * <pre>
 * -------------------------------------------------------------
 * @프로젝트 : kno
 * @파일경로 : kr.co.kno.sample.controller
 * @파일이름 : ibsheetFileImportExportController.java 
 * @작성일자 : 2020. 05. 06. 
 * @작성자명 : shkim 
 * @상세설명 : ibsheet 엑셀,텍스트 파일 다운로드,업로드 공통 처리 컨트롤러
 * -------------------------------------------------------------
 * </pre>
 */
@Controller
@RequestMapping("/ibsheet/")
public class ibsheetFileImportExportController {
    
    /**
     * 
     * <pre>
     * @MethodName : excelDown
     * @Date       : 2020. 05. 06. 
     * @Writer     : shkim
     * @Description :
     * @param request
     * @return none
     * </pre>
     */
    @RequestMapping(value = "Down2Excel.do",method= RequestMethod.POST)
	public void Down2Excel(HttpServletRequest request,HttpServletResponse response) throws Exception {
		
		response.setContentType("application/octet-stream");
	    response.setCharacterEncoding("UTF-8");
	    response.setHeader("Content-Disposition", "");
		
		// jar 및 POI 버전정보 출력. 엑셀 다운로드가 안될때 jar가 정상적으로 올라왔는지 확인용
	    // System.out.println(Version.getVersion()); 
	    IBSheetDown down = null;

	    try {
	        
	        down = new IBSheetDown();

			//====================================================================================================
			// [ 사용자 환경 설정 #0 ]
			//====================================================================================================
			// Html 페이지의 인코딩이 UTF-8 로 구성되어 있으면 "down.setEncoding("UTF-8");" 로 설정하십시오.
			// LoadExcel.jsp 도 동일한 값으로 바꿔 주십시오.
			// setService 전에 설정해야 합니다.
			//====================================================================================================
			down.setEncoding("UTF-8");
			
			//====================================================================================================
			// [ 사용자 환경 설정 #1 ]
			//====================================================================================================
			// 엑셀 전문의 MarkupTag Delimiter 사용자 정의 시 설정하세요.
			// 설정 값은 IBSheet7 환경설정(ibsheet.cfg)의 MarkupTagDelimiter 설정 값과 동일해야 합니다.
			//====================================================================================================      
			down.setMarkupTagDelimiter("┼","╫","╬","╪");
			
			//====================================================================================================
			// [ 사용자 환경 설정 #2 ]
			//====================================================================================================
			// 시트에 포함될 문자열 중 STX(\u0002), ETX(\u0003) 이 포함된 경우에만 설정해주세요.
			// 설정을 원하지 않는 경우 주석처리해주세요.
			// 0 : 시트 구분자로 STX, ETX 문자를 사용합니다. (기본값)
			// 1 : 시트 구분자로 변형된 문자열을 사용합니다. (시트에 설정이 되어 있어야 합니다.)
			//====================================================================================================
			//down.setDelimMode(1);
			
			//====================================================================================================
			// [ 사용자 환경 설정 #3 ]
			//====================================================================================================
			// HttpServletRequest, HttpServletResponse를 IBSheet 서버모듈에 등록합니다.
			//====================================================================================================
			
			 /****************************************************************************************************
	         * setService 전에 화면에서 보낸 시트 데이터를 다시 셋팅한다.
	         * 
	         ****************************************************************************************************/
	        
	        String Data = request.getParameter("Data");
	        
	        /*
	          System.out.println(Data);
	                 화면에서 전송하는 data는 xml 형식으로 되어 있다.(<0_IBCC></0_IBCC><0_IBCT></0_IBCT>)
	                 데이터가 XSS Filter을 통과하게 되면  <,> 등이 다른 문자로 변환이 되므로 아래 2가지중 하나를 적용한다.
	          1. request로 받은 Data 값을 <0_IBCC></0_IBCC><0_IBCT></0_IBCT> 되도록 치환하여 한다.
	          2. ibsheet.cfg 파일에  MarkupTagDelimiter를 설정하고 [ 사용자 환경 설정 #1 ] : setMarkupTagDelimiter를 설정한다.
	        */ 
	        
            down.setData(Data);
            
            /****************************************************************************************************
	         * setService 전에 화면에서 보낸 시트 데이터를 다시 셋팅한다.
	         * 
	         ****************************************************************************************************/
            
			down.setService(request, response);
			
			//====================================================================================================
			// [ 사용자 환경 설정 #4 ]
			//====================================================================================================
			// 다운로드 받을 문서의 타입을 설정하십시오.
			// xls   : xls 형식으로 다운로드
			// xlsx  : xlsx 형식으로 다운로드
			// excel : FileName에 설정한 값으로 다운로드, 확장자가 없는 경우 기본 xls 형식으로 다운로드
			// 
			// 두번째 인자를 통해 화면에서 부여한 파일명의 확장자를  제거하고 xls나 xlsx를 붙일지 여부를 설정(default는 false)
			//====================================================================================================
			down.setFileType("excel",false);
			
			//====================================================================================================
			// [ 사용자 환경 설정 #5 ]
			//====================================================================================================
			// 엑셀 문서에 사용될 폰트를 설정하십시오.
			// 헤더 폰트이름도 함께 설정 됩니다.
			//====================================================================================================
			//down.setFontName("맑은고딕");
			
			//====================================================================================================
			// [ 사용자 환경 설정 #6 ]
			//====================================================================================================
			// 엑셀 문서에 사용될 폰트크기를 설정하십시오.
			// 헤더 폰트크기도 함께 설정 됩니다. 
			//====================================================================================================
			//down.setFontSize(20);
			
			//====================================================================================================
			// [ 사용자 환경 설정 #7 ]
			//====================================================================================================
			// 엑셀 다운로드 시 헤더행의 배경색을 적용하고 싶은 경우에 설정하세요.
			// #3366FF 형태의 웹 컬러로 설정해주세요.
			// 설정을 원하지 않는 경우 주석처리해주세요. 
			//====================================================================================================
			//down.setHeaderBackColor("#FF2233");
			
			//====================================================================================================
			// [ 사용자 환경 설정 #8 ]
			//====================================================================================================
			// 엑셀 다운로드 시 헤더행의 폰트 Bold 스타일을 적용하고 싶은 경우에 설정하세요.
			// 설정을 원하지 않는 경우 주석처리해주세요.
			//====================================================================================================
			//down.setHeaderFontBold(false);
			
			//====================================================================================================
			// [ 사용자 환경 설정 #9 ]
			//====================================================================================================
			// 엑셀 다운로드 시 헤더행의 글자색을 적용하고 싶은 경우에 설정하세요.
			// #3366FF 형태의 웹 컬러로 설정해주세요.
			// 설정을 원하지 않는 경우 주석처리해주세요.
			//====================================================================================================
			//down.setHeaderFontColor("#FFFFFF");
			
			//====================================================================================================
			// [ 사용자 환경 설정 #10 ]
			//====================================================================================================
			// 엑셀 다운로드 시 헤더행의 폰트를 적용하고 싶은 경우에 설정하세요.
			// 설정을 원하지 않는 경우 주석처리해주세요.
			//====================================================================================================
			//down.setHeaderFontName("궁서");
			
			//====================================================================================================
			// [ 사용자 환경 설정 #11 ]
			//====================================================================================================
			// 엑셀 다운로드 시 헤더행의 폰트 크기를 적용하고 싶은 경우에 설정하세요.
			// 설정을 원하지 않는 경우 주석처리해주세요.
			//====================================================================================================
			//down.setHeaderFontSize(20);
			
			//====================================================================================================
			// [ 사용자 환경 설정 #12 ]
			//====================================================================================================
			// 줄바꿈 설정을 다음에서 설정한 값으로 강제적으로 적용합니다.
			// 사용하지 않으시려면 주석처리 하세요.
			//====================================================================================================
			//down.setWordWrap(false);
			
			//====================================================================================================
			// [ 사용자 환경 설정 #13 ]
			//====================================================================================================
			// 엑셀 다운로드 시 서버에 위치한 디자인 파일을 사용하는 경우 디자인 파일이 있는 폴더 위치를 설정하세요.
			// 디자인 파일을 사용하지 않는 경우 주석처리하세요. 
			//====================================================================================================
			//down.setTempRoot("D:/SVN/src/IBSheet7.TestPage");
			
			//====================================================================================================
			// [ 사용자 환경 설정 #14 ]
			//====================================================================================================
			// 트리 컬럼에서 레벨별로 … 를 덧붙여서 레벨별로 보기 좋게 만듭니다.
			// 만약 … 대신 다른 문자를 사용하기를 원하시면 아래 유니코드 \u2026 (16진수형태) 대신 다른 문자를 입력하십시오.
			// 트리 컬럼이 없으면 설정하지 마세요.
			//====================================================================================================
			//down.setTreeChar("\u2026");
			
			//====================================================================================================
			// [ 사용자 환경 설정 #15 ]
			//====================================================================================================
			// 엑셀에 포함될 이미지의 URL 이 같은 도메인에 있지만 "/image/imgDown.jsp?idx=365" 등과 같은 
			// 이미지 로딩 방식을 사용한다면 웹서버 도메인을 설정하세요.
			//====================================================================================================
			//down.setWebServerDomain("http://www.ibleaders.co.kr");
			
			//====================================================================================================
			// [ 사용자 환경 설정 #16 ]
			//====================================================================================================
			// 엑셀에 포함될 숫자 형식 데이터를 [통화] 나 [사용자정의] 가 아닌 [숫자] 서식으로 다운로드 합니다.
			// 시트에서 Down2Excel 옵션으로 설정한 NumberExMode를 무시하고 적용됩니다.
			//====================================================================================================
			//down.setNumberExMode(true);
			
			//====================================================================================================
			// [ 사용자 환경 설정 #17 ]
			//====================================================================================================
			// POI 라이브러리를 사용중이고 XLSX 형식의 파일을 다운로드 할 때 임시폴더를 사용하지 않고 메모리에서 직접
			// 다운로드 받도록 설정합니다.
			// 메모리 사용량이 늘어나게 되므로 임시폴더를 사용할 수 없는 환경에서만 설정해 주세요.
			//====================================================================================================
			//down.setXlsxTempFolderMode(true);
			
			//====================================================================================================
			// [ 사용자 환경 설정 #18 ]
			//====================================================================================================
			// 엑셀 다운로드 시 포함된 이미지의 비율을 맞추고 싶을때 설정하세요..
			// 설정을 원하지 않는 경우 주석처리해주세요.
			// 0 : 셀의 가로/세로에 꽉 차게 이미지를 처리합니다. (기본값)
			// 1 : 셀의 중앙에 이미지를 원본 크기로 표시합니다.
			// 2 : 이미지의 원본 가로/세로 비율을 유지하면서 셀에 맞춥니다.
			//====================================================================================================
			down.setImageProcessType(2);
			
			//====================================================================================================
			// [ 사용자 환경 설정 #19 ]
			//====================================================================================================
			// 엑셀 파일의 인쇄 항목을 설정하고 싶은 경우에 설정하세요.
			// 설정을 원하지 않는 경우 주석처리해주세요.
			//====================================================================================================
			/**
			ExcelPrintSetup printSetup = new ExcelPrintSetup();
			//컬러 인쇄 여부를 설정합니다. 기본값은 true입니다. false로 설정하면 흑백인쇄 모드가 됩니다.
			printSetup.setColorPrint(true);
			//용지 사이즈를 설정합니다. 설정 가능한 용지는 Letter, Legal, A3, A4, A5, B4, B5 입니다.
			printSetup.setPageSize("A4");
			//용지 방향을 설정합니다. true는 가로, false는 세로 방향입니다.
			printSetup.setLandscape(true);
			//페이지를 나눌때 셀이 잘리지 않도록 설정합니다.
			printSetup.setAutoBreak(true);
			//용지 내에 페이지를 맞춰서 인쇄할 때 사용합니다.
			printSetup.setFitToPage(true);
			// 페이지 내에 열맞춤을 설정합니다. 이 옵션을 사용하려면 setFitToPage(true); 와 setFitHeight(false); 를 함께 설정해야 합니다.
			printSetup.setFitWidth(true);
			// 페이지 내에 행맞춤을 설정합니다. 이 옵션을 사용하려면 setFitToPage(true); 와 setFitWidth(false); 를 함께 설정해야 합니다.
			printSetup.setFitHeight(false);
			//머리글 부분의 여백을 Cm 단위로 설정합니다.
			printSetup.setHeaderMargin(0d);
			//꼬리글 부분의 여백을 Cm 단위로 설정합니다.
			printSetup.setFooterMargin(0d);
			//위쪽 여백을 Cm 단위로 설정합니다.
			printSetup.setTopMargin(0.5);
			//아래쪽 여백을 Cm 단위로 설정합니다.
			printSetup.setBottomMargin(0.5);
			//왼쪽 여백을 Cm 단위로 설정합니다.
			printSetup.setLeftMargin(0.5);
			//오른쪽 여백을 Cm 단위로 설정합니다.
			printSetup.setRightMargin(0.5);
			//엑셀 파일의 인쇄 설정을 파일에 적용합니다.
			down.setPrintSetup(printSetup);
			**/
			//====================================================================================================
			// [ 사용자 환경 설정 #20 ]
			//====================================================================================================
			// 트리 사용 시트에서 트리구조를 엑셀 파일에 반영할지 여부(엑셀의 그룹기능 사용)
			// Default가 true로 사용하지 않고자 하는 경우 false로 설정
			//====================================================================================================
			//down.setUseGroupTree(false);
			
			  // 다운로드 1. 생성된 문서를 브라우저를 통해 다운로드
			  down.downToBrowser();
			
			  // 다운로드 2. 생성된 엑셀 문서를 서버에 저장
			  /*
			  String fileName = down.getFileName();
			
			// Password를 사용하려면 이 부분에서 IBSheet에서 전달된 패스워드를 취득해야 합니다.
			String passWord = down.getWorkbookPassword();
			
			  down.saveToFile("d:/");
			
			  // 생성된 엑셀 문서를 다운로드 처리(이 부분에서 엑셀문서를 DRM 처리함)
			  File file = new File("d:/"  + fileName); 
			  
			
			// 패스워드 설정은 XLSX 형식의 파일이 대상이고 POI 라이브러리를 사용할 때만 가능합니다.
			if (fileName.toLowerCase().endsWith(".xlsx") && !"".equals(passWord)) {
			
			File pFile = new File("d:/encrypt.xlsx");
			FileOutputStream fout = new FileOutputStream(pFile);
			
			//서버 내에 암호화된 엑셀파일을 생성합니다.
			com.ibleaders.ibsheet.excel.ProtectXLSX.encryptXLSX("d:/", passWord, file, fout);
			
			//원본 파일을 지웁니다.
			file.delete();
			
			//다운로드할 대상을 암호화된 엑셀파일로 설정합니다.
			file = pFile;
			
			}
			
			//서버 내에 저장된 파일을 다운로드.
			try {
			if (file.isFile()) {
				
				int fileLength = (int)file.length();
				
				// 사용자의 브라우저에 다운로드할 파일의 정보를 전달합니다.
				down.setFileHeader();
				response.setContentLength(fileLength);
				
				FileInputStream fileIn = new FileInputStream(file);
				ServletOutputStream out3 = response.getOutputStream();
			
				byte[] outputByte = new byte[fileLength];
			
				while (fileIn.read(outputByte, 0, fileLength) != -1) {
					out3.write(outputByte, 0, fileLength);
				}
			
				fileIn.close();
				out3.flush();;
				out3.close();
			} 
			} finally {
			file.delete();
			}
			*/

	    } catch (Exception e) {
	    	
			//e.printStackTrace();
	    	
			response.setContentType("text/html;charset=utf-8");
			response.setCharacterEncoding("utf-8");
			response.setHeader("Content-Disposition", "");
			
			OutputStream out2 = response.getOutputStream();
			out2.write(("<script>alert('An error has occurred while downloading the file.');</script>").getBytes());
			out2.flush();
	    } catch (Error e) {

			//e.printStackTrace();
	    	
			response.setContentType("text/html;charset=utf-8");
			response.setCharacterEncoding("utf-8");
			response.setHeader("Content-Disposition", "");
			
			OutputStream out2 = response.getOutputStream();
			out2.write(("<script>alert('An error has occurred while downloading the file.');</script>").getBytes());
			out2.flush();
				
	    } finally {
	        if (down != null) {
	        	down.close();
	        }
	        down = null;
	    }

	}
	
	@RequestMapping(value = "LoadExcel.do", method = RequestMethod.POST)
	public void LoadExcel(HttpServletRequest request,HttpServletResponse response, @RequestParam("file") MultipartFile excelFile) throws Exception {
		
		response.setContentType("text/html;charset=utf-8");
        response.setCharacterEncoding("utf-8");
        response.setHeader("Content-Disposition", "");		
		
		IBSheetLoad load = null;
	    File tempfile = null;
	    
	    try {

	        load = new IBSheetLoad();

	        //====================================================================================================
	        // [ 사용자 환경 설정 #0 ]
	        //====================================================================================================
	        // Html 페이지의 인코딩이 UTF-8 로 구성되어 있으면 "load.setEncoding("UTF-8");" 로 설정하십시오.
	        // 한글 헤더가 있는 그리드에서 엑셀 로딩이 동작하지 않으면 이 값을 바꿔 보십시오.
	        // Down2Excel.jsp 에서의 설정값과 동일하게 바꿔주십시오.
	        // setService 전에 설정해야 합니다.
	        //====================================================================================================
	        load.setEncoding("UTF-8");

	        //====================================================================================================
	        // [ 사용자 환경 설정 #1 ]
	        //====================================================================================================
	        // 엑셀 전문의 MarkupTag Delimiter 사용자 정의 시 설정하세요.
	        // 설정 값은 IBSheet7 환경설정(ibsheet.cfg)의 MarkupTagDelimiter 설정 값과 동일해야 합니다.
	        //====================================================================================================      
	        load.setMarkupTagDelimiter("┼","╫","╬","╪");

			//====================================================================================================
			// [ 사용자 환경 설정 #2 ]
			//====================================================================================================
			// 시트에 포함될 문자열 중 STX(\u0002), ETX(\u0003) 이 포함된 경우에만 설정해주세요.
			// 설정을 원하지 않는 경우 주석처리해주세요.
			// 0 : 시트 구분자로 STX, ETX 문자를 사용합니다. (기본값)
			// 1 : 시트 구분자로 변형된 문자열을 사용합니다. (시트에 설정이 되어 있어야 합니다.)
			//====================================================================================================
			//load.setDelimMode(1);

			//====================================================================================================
			// [ 사용자 환경 설정 #3 ]
			//====================================================================================================
			// 엑셀의 머지된 셀의 처리를 설정합니다.
			// true인 경우 머지된 셀의 첫번째 셀 기준으로 데이터를 로드하고(기본값),  false인 경우에는 로드하지 않습니다.
			//====================================================================================================      
			//load.setMergeProcess(false);


			//====================================================================================================
			// [ 사용자 환경 설정 #4 ]
			//====================================================================================================
			// HeaderMatch 사용 시 시트에 있는 헤더가 엑셀에 하나라도 존재하지 않는 경우 오류메시지를 출력하고 데이터를 로딩하지 않을지 여부.
			//====================================================================================================
			//load.setStrictHeaderMatch(true);

			//====================================================================================================
			// [ 사용자 환경 설정 #5 ]
			//====================================================================================================
			// LoadExcel 처리를 허용할 최대 행 수를 설정한다.
			// 엑셀 데이터가 지정한 행 수보다 많은 경우 메시지를 출력하고 처리가 종료된다.
			//====================================================================================================
			//load.setMaxRows(100);

			//====================================================================================================
			// [ 사용자 환경 설정 #6 ]
			//====================================================================================================
			// LoadExcel 처리를 허용할 최대 열 수를 설정한다.
			// 엑셀 데이터가 지정한 열 수보다 많은 경우 메시지를 출력하고 처리가 종료된다.
			//====================================================================================================
			//load.setMaxColumns(20);

			//====================================================================================================
			// [ 사용자 환경 설정 #7 ]
			//====================================================================================================
			// 엑셀의 비어있는 행도 로드하도록 설정한다.
			// false로 설정하는 경우 비어있는 행을 로드하고, true인 경우에는 비어있는 행을 건너뛴다.
			// 시트의 LoadExcel({ SkipEmptyRow  : false }); 옵션과 동일하게 작동한다.
			// LoadExcel에서 StartRow를 설정한 경우, 해당 행은 검사하지 않는다.
			//====================================================================================================
			//load.setSkipEmptyRow(false);
			
			//====================================================================================================
			// [ 사용자 환경 설정 #8 ]
			//====================================================================================================
			// 업로드 가능한 최대 파일 사이즈를 설정한다.
			// kb 단위로 1024 * 5 로 설정시 5MB를 의미한다.
			//====================================================================================================
			//load.setMaxFileSize(1024 * 5);

			//====================================================================================================
			// HttpServletRequest, HttpServletResponse를 IBSheet 서버모듈에 등록합니다.
			//====================================================================================================
	        
	        /****************************************************************************************************
	         * setService 전에 화면에서 보낸 시트 데이터를 다시 셋팅한다.
	         * 
	         ****************************************************************************************************/
	        
	        //임시로 파일을 써야 할 java 임시 저장소
            String tempPath = System.getProperty("java.io.tmpdir");
            //임시 파일명 + 확장자
            String tempFileName =  UUID.randomUUID().toString().replaceAll("-", "") + excelFile.getOriginalFilename().substring(excelFile.getOriginalFilename().lastIndexOf("."));
            
            //임시파일
            tempfile = new File(tempPath+tempFileName);
            
            //화면에서 받은 파일을 임시파일에 저장
            excelFile.transferTo(tempfile);
            
            String Data = request.getParameter("columnTag");
            /*
	          System.out.println(Data);
	                 화면에서 전송하는 data는 xml 형식으로 되어 있다.(<0_IBCC></0_IBCC><0_IBCT></0_IBCT>)
	                 데이터가 XSS Filter을 통과하게 되면  <,> 등이 다른 문자로 변환이 되므로 아래 2가지중 하나를 적용한다.
	          1. request로 받은 Data 값을 <0_IBCC></0_IBCC><0_IBCT></0_IBCT> 되도록 치환하여 한다.
	          2. ibsheet.cfg 파일에  MarkupTagDelimiter를 설정하고 [ 사용자 환경 설정 #1 ] : setMarkupTagDelimiter를 설정한다.
	        */ 
            
            //데이터와 파일을 전달한다.
            load.setData(Data,tempfile.getAbsolutePath());
            
            /****************************************************************************************************
	         * setService 전에 화면에서 보낸 시트 데이터를 다시 셋팅한다.
	         * 
	         ****************************************************************************************************/
            
			load.setService(request, response);

	        
			/** 서버로 전송된 파일을 가공해서 사용해야 할 경우. (예, DRM 복호화 등)
	        // 서버에 저장된 파일 객체
	        File uploadFile = load.getUploadFile();
			String uploadFileName = uploadFile.getName();
			String uploadFilePath = uploadFile.getAbsolutePath();

	        // TODO
	        // 업로드된 엑셀 파일을 가공함 (예, 엑셀문서를 DRM 처리함)
			
			// 가공된 파일을 ibSheet에서 읽을 수 있도록 처리.
			load.loadFile(uploadFile);
			**/

	        //브라우저에 데이터를 전달하여 시트에 로드
	        load.writeToBrowser();

	    } catch (Exception e) {
	        //e.printStackTrace();
	    	
	        OutputStream out2 = response.getOutputStream();
	        out2.write(load.getLoadError());
	        out2.flush();
	    } catch (Error e) {

	        //e.printStackTrace();
	    	
	    	OutputStream out2 = response.getOutputStream();
	        out2.write(load.getLoadError());
	        out2.flush();
	    } finally {
	        if (load != null) {
	            load.close();
	        }
	        load = null;
	    }
	}
	
	@RequestMapping(value = "Down2Text.do",method= RequestMethod.POST)
	public void Down2Text(HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		response.setContentType("application/octet-stream");
	    response.setCharacterEncoding("UTF-8");
	    response.setHeader("Content-Disposition", "");

	    IBSheetDown down = null;
	    

	    try {

	        down = new IBSheetDown();

	        //====================================================================================================
	        // [ 사용자 환경 설정 #0 ]
	        //====================================================================================================
	        // Html 페이지의 인코딩이 UTF-8 로 구성되어 있으면 "down.setEncoding("UTF-8");" 로 설정하십시오.
	        // LoadText.jsp 도 동일한 값으로 바꿔 주십시오.
	        // setService 전에 설정해야 합니다.
	        //====================================================================================================
	        down.setEncoding("UTF-8");
	        
	      //====================================================================================================
	        // [ 사용자 환경 설정 #1 ]
	        //====================================================================================================
	        // 엑셀 전문의 MarkupTag Delimiter 사용자 정의 시 설정하세요.
	        // 설정 값은 IBSheet7 환경설정(ibsheet.cfg)의 MarkupTagDelimiter 설정 값과 동일해야 합니다.
	        //====================================================================================================      
	        down.setMarkupTagDelimiter("┼","╫","╬","╪");

	        
		    //====================================================================================================
	        // [ 사용자 환경 설정 #2 ]
	        //====================================================================================================
	        // HttpServletRequest, HttpServletResponse를 IBSheet 서버모듈에 등록합니다.
	        //====================================================================================================
	        
	        /****************************************************************************************************
	         * setService 전에 화면에서 보낸 시트 데이터를 다시 셋팅한다.
	         * 
	         ****************************************************************************************************/
			String Data = request.getParameter("Data");
			   
			/*
			  System.out.println(Data);
			         화면에서 전송하는 data는 xml 형식으로 되어 있다.(<0_IBCC></0_IBCC><0_IBCT></0_IBCT>)
			         데이터가 XSS Filter을 통과하게 되면  <,> 등이 다른 문자로 변환이 되므로 아래 2가지중 하나를 적용한다.
			  1. request로 받은 Data 값을 <0_IBCC></0_IBCC><0_IBCT></0_IBCT> 되도록 치환하여 한다.
			  2. ibsheet.cfg 파일에  MarkupTagDelimiter를 설정하고 [ 사용자 환경 설정 #1 ] : setMarkupTagDelimiter를 설정한다.
			*/ 
			   
			down.setData(Data);
			/****************************************************************************************************
			 * setService 전에 화면에서 보낸 시트 데이터를 다시 셋팅한다.
			 * 
			 ****************************************************************************************************/
	        
	        down.setService(request, response);

	        //====================================================================================================
	        // [ 사용자 환경 설정 #3 ]
	        //====================================================================================================
	        // 다운로드 받을 문서의 타입을 설정하십시오.
	        // txt : txt 형식으로 다운로드
	        //====================================================================================================        
	        down.setFileType("txt");
			
			
	        //====================================================================================================
	        // [ 사용자 환경 설정 #4 ]
	        //====================================================================================================
	        // 텍스트 파일의 행 구분자를 설정하십시오. (시트의 RowDelim 설정이 우선 적용)
	        //====================================================================================================      
	        //down.setTextLine("\n");

	        //====================================================================================================
	        // [ 사용자 환경 설정 #5 ]
	        //====================================================================================================
	        // 텍스트 파일의 열 구분자를 설정하십시오. (시트의 ColDelim 설정이 우선 적용)
	        //====================================================================================================      
	        //down.setTextSpliter("\t");

	        // 생성된 문서를 브라우저를 통해 다운로드
	        down.downToBrowser();

	    } catch (Exception e) {

			//e.printStackTrace();
	    	
	    	response.setContentType("text/html;charset=utf-8");
			response.setCharacterEncoding("utf-8");
			response.setHeader("Content-Disposition", "");
			
			OutputStream out2 = response.getOutputStream();
			out2.write(("<script>alert('An error has occurred while downloading the file.');</script>").getBytes());
			out2.flush();

	    } catch (Error e) {

			//e.printStackTrace();
	    	
	    	response.setContentType("text/html;charset=utf-8");
			response.setCharacterEncoding("utf-8");
			response.setHeader("Content-Disposition", "");
			
			OutputStream out2 = response.getOutputStream();
			out2.write(("<script>alert('An error has occurred while downloading the file.');</script>").getBytes());
			out2.flush();
			
	    } finally {
	        if (down != null) {
	        	 down.close();
	        }
	        down = null;
	    }

	}
	
	@RequestMapping(value = "LoadText.do", method = RequestMethod.POST)
	public void LoadText(HttpServletRequest request,HttpServletResponse response, @RequestParam("file") MultipartFile txtFile) throws Exception {
		
		response.setContentType("text/html;charset=utf-8");
        response.setCharacterEncoding("utf-8");
        response.setHeader("Content-Disposition", "");	
        
	    IBSheetLoad load = null;
	    File tempfile = null;

	    try {

	        load = new IBSheetLoad();

	        //====================================================================================================
	        // [ 사용자 환경 설정 #0 ]
	        //====================================================================================================
	        // Html 페이지의 엔코딩이 UTF-8 로 구성되어 있으면 "load.setEncoding("UTF-8")" 로 설정하십시오.
	        // 한글 헤더가 있는 그리드에서 엑셀 로딩이 동작하지 않으면 이 값을 바꿔 보십시오.
	        // LoadText.jsp 에서의 설정값과 동일하게 바꿔주십시오.
	        // setService 전에 설정해야 합니다.
	        //====================================================================================================
	        load.setEncoding("UTF-8");
	        
	      //====================================================================================================
	        // [ 사용자 환경 설정 #1 ]
	        //====================================================================================================
	        // 엑셀 전문의 MarkupTag Delimiter 사용자 정의 시 설정하세요.
	        // 설정 값은 IBSheet7 환경설정(ibsheet.cfg)의 MarkupTagDelimiter 설정 값과 동일해야 합니다.
	        //====================================================================================================      
	        load.setMarkupTagDelimiter("┼","╫","╬","╪");

	        
	        //====================================================================================================
	        // [ 사용자 환경 설정 #2 ]
	        //====================================================================================================
	        // HttpServletRequest, HttpServletResponse를 IBSheet 서버모듈에 등록합니다.
	        //====================================================================================================
	        
	        /****************************************************************************************************
	         * setService 전에 화면에서 보낸 시트 데이터를 다시 셋팅한다.
	         * 
	         ****************************************************************************************************/
	        
	        //임시로 파일을 써야 할 java 임시 저장소
            String tempPath = System.getProperty("java.io.tmpdir");
            //임시 파일명 + 확장자
            String tempFileName =  UUID.randomUUID().toString().replaceAll("-", "") + txtFile.getOriginalFilename().substring(txtFile.getOriginalFilename().lastIndexOf("."));
            
            //임시파일
            tempfile = new File(tempPath+tempFileName);
            
            //화면에서 받은 파일을 임시파일에 저장
            txtFile.transferTo(tempfile);
            
            String Data = request.getParameter("columnTag");
            /*
	          System.out.println(Data);
	          화면에서 전송하는 data는 xml 형식으로 되어 있다.(<0_IBCC></0_IBCC><0_IBCT></0_IBCT>)
	          데이터가 XSS Filter을 통과하게 되면  <,> 등이 다른 문자로 변환이 되므로 아래 2가지중 하나를 적용한다.
	          1. request로 받은 Data 값을 <0_IBCC></0_IBCC><0_IBCT></0_IBCT> 되도록 치환하여 한다.
	          2. ibsheet.cfg 파일에  MarkupTagDelimiter를 설정하고 [ 사용자 환경 설정 #1 ] : setMarkupTagDelimiter를 설정한다.
	        */ 
            
            //데이터와 파일을 전달한다.
            load.setData(Data,tempfile.getAbsolutePath());
            
            /****************************************************************************************************
	         * setService 전에 화면에서 보낸 시트 데이터를 다시 셋팅한다.
	         * 
	         ****************************************************************************************************/
	        
	        
	        load.setService(request, response);
	        
	    	
	        //브라우저에 데이터를 전달하여 시트에 로드
	        load.writeToBrowser();

	    } catch (Exception e) {
	        //e.printStackTrace();
	        OutputStream out2 = response.getOutputStream();
	        out2.write(load.getLoadError());
	        out2.flush();

	    } catch (Error e) {
	        OutputStream out2 = response.getOutputStream();
	        out2.write(load.getLoadError());
	        out2.flush();
	        //e.printStackTrace();
	    } finally {
	        if (load != null) {
	            load.close();
	        }
	        load = null;
	    }
	}
}
